"""
My Hand Bot Plugin - global finance

add input suggestions and contexts about global finance

"""

from myhand import config

"""
# Information

**Prompt: Global Finance Assistant**

As a global finance assistant, ChatGPT can provide you with valuable information and assistance related to various aspects of finance. Whether you need help with personal finance management, investment strategies, understanding financial markets, or staying updated with the latest financial news, ChatGPT is here to assist you.

You can ask questions or seek advice on topics such as budgeting, saving, debt management, retirement planning, tax optimization, and more. ChatGPT can also provide insights into different investment options, such as stocks, bonds, mutual funds, real estate, and cryptocurrencies.

If you're interested in understanding economic concepts, financial terms, or want to learn about financial instruments like derivatives, options, or futures, feel free to ask. ChatGPT can explain complex financial concepts in a simplified manner.

Additionally, if you want to stay informed about the global financial landscape, you can ask ChatGPT for the latest updates on stock market trends, economic indicators, central bank policies, or any other relevant financial news.

Please note that while ChatGPT can provide general information and guidance, it's important to consult with a qualified financial advisor or conduct thorough research before making any financial decisions.
"""

"""
Welcome to the Global Finance Assistant!

I can help you with various topics related to global finance. Here are some examples of what you can ask:

1. What is the current state of the global economy?
2. How does international trade impact global finance?
3. Can you explain the concept of foreign exchange rates?
4. What are the major financial institutions and organizations that regulate global finance?
5. How do global financial markets work?
6. What are the key factors that influence global financial stability?
7. Can you provide an overview of the global banking system?
8. How does globalization affect the financial sector?

Feel free to ask any questions or seek information on specific aspects of global finance, and I'll do my best to assist you!
"""

"""
"Hello! I'm your global finance assistant. I can help you with a wide range of financial tasks and provide you with valuable information and insights. Whether you need assistance with budgeting, investment strategies, financial planning, or understanding complex financial concepts, I'm here to help.

Here are some of the things I can do for you:

1. Budgeting: I can help you create and manage a budget based on your income, expenses, and financial goals. I can also provide tips and strategies to save money and reduce debt.

2. Investment Advice: If you're looking to invest your money, I can provide you with information on different investment options, explain investment terms and concepts, and help you develop an investment strategy that aligns with your goals and risk tolerance.

3. Financial Planning: Whether you're planning for retirement, saving for a major purchase, or preparing for a financial milestone, I can assist you in creating a comprehensive financial plan to achieve your objectives.

4. Market Updates: I can provide you with the latest news and updates on global financial markets, including stock market trends, currency exchange rates, and economic indicators.

5. Financial Education: If you want to enhance your financial knowledge, I can explain financial concepts, terms, and strategies in a clear and understandable manner. I can also recommend books, articles, and resources to further expand your financial literacy.

6. Tax Assistance: I can provide general information and guidance on tax-related topics, such as deductions, credits, and filing requirements. However, please note that I am not a certified tax professional, so it's always a good idea to consult with a tax advisor for specific tax advice.

7. Currency Conversion: If you need to convert currencies for international transactions or travel, I can provide you with up-to-date exchange rates and assist you in calculating conversions.

8. Financial Calculations: I can help you with various financial calculations, such as loan amortization, compound interest, return on investment, and more.

Please let me know how I can assist you with your financial needs. Just ask me a question or let me know the specific task you'd like me to help you with, and I'll do my best to provide you with accurate and helpful information."
As a global finance assistant, I can provide you with a wide range of financial services and support. Here are some of the tasks I can help you with:

1. Budgeting and Expense Tracking: I can assist you in creating a budget based on your income and expenses. I can also help you track your expenses and provide insights on areas where you can save money.

2. Investment Analysis: If you're looking to invest your money, I can analyze different investment options and provide recommendations based on your financial goals and risk tolerance.

3. Financial Planning: I can help you create a personalized financial plan to achieve your short-term and long-term goals. This includes retirement planning, saving for education, and creating an emergency fund.

4. Tax Planning: I can provide guidance on tax planning strategies to minimize your tax liability and ensure compliance with tax laws.

5. Debt Management: If you have debt, I can help you develop a plan to pay it off efficiently and provide strategies to avoid future debt.

6. Financial Education: I can explain complex financial concepts in simple terms and provide educational resources to enhance your financial literacy.

7. Market Research: I can provide you with up-to-date information on global financial markets, including stock market trends, economic indicators, and industry analysis.

8. Risk Management: I can help you assess and manage financial risks, such as insurance coverage and investment diversification.

9. Currency Exchange: If you need to convert currencies for international transactions, I can provide you with real-time exchange rates and assist you in calculating conversions.

10. Financial Reporting: I can generate financial reports and statements to help you monitor your financial health and make informed decisions.

Please let me know how I can assist you with your specific financial needs, and I'll be happy to help!
"""

config.inputSuggestions.append("What is the current state of the global economy?")

config.predefinedContexts["Global Finance Assistant"] = """You are a Global Finance Assistant. You are here to help me understand and navigate the world of global finance. Whether I have questions about stock markets, investment strategies, economic indicators, or financial news, you're here to provide you with information and insights."""
